'use strict';

const Controller = require('egg').Controller;
class JobController extends Controller {
  async info() {
    const { ctx, service } = this;
    if (ctx.params.city_code === 'undefined') { return ctx.throw(422, 'city_code is missing!'); }


    ctx.success({ results: blocks });
  }

  async list() {
    const { ctx, service } = this;
    if (ctx.params.jobtypeid === 'undefined') { return ctx.throw(422, 'job_style is missing!'); }
    let job_type_id = ctx.params.jobtypeid;
    const ret = await service.official.job.job.get_list( { job_type_id: job_type_id } );
    ctx.success({ results: ret });
  }

  async all() {
    const { ctx, service } = this;
    if (ctx.params.jobtype === 'undefined') { return ctx.throw(422, 'job_style is missing!'); }
    let job_type = ctx.params.jobtype;
    const job_types = await service.official.job.type.get_list( { job_type: job_type } );
    
    var jobs = [];
    for(const item of job_types ) {
      let job_type_id = item.id;
      let ret = await service.official.job.job.get_list( { job_type_id: job_type_id } );
      jobs.push({
        id: item.id,
        name: item.name,
        icon: item.icon,
        background: item.background,
        jobs: ret, 
      });
    }
    
    ctx.success({ results : jobs });
  }

  async apply() {
    const { service, ctx } = this;
    const input_params = ctx.request.body;

    console.log(input_params);
    console.log(ctx.request);
    // 招聘岗位de id号
    if (typeof (input_params.job_id) === 'undefined' || !input_params.job_id) {
      return ctx.throw(422, 'job_id is missing!');
    }
    //求职者姓名
    if (typeof (input_params.name) === 'undefined' || !input_params.name) {
      return ctx.throw(422, 'name is missing!');
    }
    //求职者手机号
    if (typeof (input_params.telephone) === 'undefined' || !input_params.telephone) {
      return ctx.throw(422, 'telephone is missing!');
    }
    //求职者邮箱 
    if (typeof (input_params.email) === 'undefined' || !input_params.email) {
      return ctx.throw(422, 'email is missing!');
    } 
    //求职者学校   
    if (typeof (input_params.school) === 'undefined' || !input_params.school) {
      return ctx.throw(422, 'school is missing!');
    } 
    //求职者专业   
    if (typeof (input_params.major) === 'undefined' || !input_params.major) {
      return ctx.throw(422, 'major is missing!');
    }    
    //求职者简历  
    if (typeof (input_params.resume) === 'undefined' || !input_params.resume) {
      return ctx.throw(422, 'resume is missing!');
    }  

    //邀请码  
    if (typeof (input_params.code) === 'undefined') {
      return ctx.throw(422, 'code is missing!');
    }  

    const ret = await service.official.job.apply.apply(input_params);
    ctx.success({ results: ret });
    
  }

  async school_recruit() {

    //默认是公积金管家的app_type_id
    const school_recruitInfo = service.block.get_block_info({ app_type_id: '2150d0f1-ee07-4d17-a019-251be3699bd1', alias: 'official_school_recruit' });
    const school_recruits = await this.formatBlock(school_recruitInfo);
    //以下老版本的 取消
    // const { ctx } = this;
    // let filter = {
    //   where: {
    //     location: 'official_school_recruit',
    //     status: 1,
    //     valid: 1,
    //   },
    // };
    // const banner_type = await ctx.huodongModel.BannerType.findOne(filter);
    // if (!banner_type) {
    //   ctx.failed('错误的location');
    // }

    // filter = {
    //   where: {
    //     banner_id: banner_type.sid,
    //   },
    // };
    // const banners = await ctx.huodongModel.Banner.findAll(filter);
    const result = {};
    let i = 0;
    
    for (const v of school_recruits) {
      if(i == 1) {
        return false;
      }
      result.banner_id = v.id;
      result.image = v.logo;
      result.url = v.link;
      result.title = v.title;
      result.type = 'video';

      i++;
    }

    ctx.success({ results: result });   
  }

  async formatBlock(block) {
    if (block.length === 0) {
      return [];
    }

    const ret = [];
    for (const v of block) {
      const tmp = {
        id: v.id,
        title: v.title,
        sub_title: v.subtitle,
        description: v.description,
        link: v.link,
        logo: v.logo,
        sort: v.sort,
      };

      ret.push(tmp);
    }

    return ret;
  }
}

module.exports = JobController;
