
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const R = require('ramda');
const GENDER = {
    boy: '小王子',
    girl: '小公举'
}

class UserService extends Service {


    async getBabyInfo() {

        const { ctx } = this;
        const user_id = 1;
        const app_type_id = 1;
        const app_user_id = 1;
        const app_id = 1;
        const where = { user_id, is_deleted: 0 };
        const baby_info = await ctx.prometheusModel.CourseUserBaby.one({ where, });
        let ret = {};
        if (baby_info && baby_info.id) {
            ret.id = baby_info.id;
            ret.gender = baby_info.gender;
            ret.birth = baby_info.birth;
            ret.address = baby_info.address;
            ret.gender_text = GENDER[ret.gender];
            ret.age = moment().format('YYYY') - baby_info.birth.substr(0, 4);
        }

        return ret;
    }

    async saveBabyInfo(input) {

        const { ctx } = this;
        const user_id = 1;
        const app_type_id = 1;
        const app_user_id = 1;
        const app_id = 1;
        const { gender, birth, address } = input;
        const baby_info = await this.getBabyInfo();
        const where = { user_id, is_deleted: 0 };
        if (baby_info && baby_info.id) {
            await ctx.prometheusModel.CourseUserBaby.edit({ params: { gender, birth, address }, where });
        } else {
            await ctx.prometheusModel.CourseUserBaby.add({ user_id, app_type_id, app_user_id, app_id, gender, birth, address });
        }

        return true;
    }

    async delBabyInfo() {

        const { ctx } = this;
        const user_id = 1;
        const app_type_id = 1;
        const app_user_id = 1;
        const app_id = 1;

        await ctx.prometheusModel.CourseUserBaby.edit({ params: { is_deleted: 1, }, where: { user_id } });

        return true;
    }

    async collectInstitution(institution_id) {

        const { ctx } = this;
        const user_id = 1;
        const app_type_id = 1;
        const app_user_id = 1;
        const app_id = 1;
        const where = { user_id, is_deleted: 0 };
        let ret = await ctx.prometheusModel.CourseUserCollection.one({ where, });
        if (ret && ret.id) {
            return ret.id;
        }
        ret = await await ctx.prometheusModel.CourseUserCollection.add({ user_id, app_type_id, app_user_id, app_id, institution_id });

        return ret;
    }

    async getCollectInstitutions(input) {

        const { ctx } = this;
        const user_id = 1;
        const app_type_id = 1;
        const app_user_id = 1;
        const app_id = 1;
        const { page, limit } = input;
        const where = { user_id, is_deleted: 0 };
        const collect_institution_rows = await ctx.prometheusModel.CourseUserCollection.list({ page, limit, where });
        const institution_ids = R.pluck('institution_id', collect_institution_rows.rows);
        if (institution_ids.length === 0) {
            return { page: collect_institution_rows.page, count: collect_institution_rows.count, rows: [] };
        }
        const institutions = await ctx.prometheusModel.CourseInstitution.all({ where: { id: { $in: institution_ids }, status: 1, is_deleted: 0 } });
        const ret = await ctx.service.course.institution.formatInstitutions(institutions);
        return { page: collect_institution_rows.page, count: collect_institution_rows.count, rows: ret };

    }


}

module.exports = UserService;
