'use strict';
module.exports = app => {
  const { STRING, INTEGER } = app.Sequelize;

  const HouseBizcircle = app.blockModel.define('house_bizcircle', {
    id: {
      type: INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    name: STRING,
    spell: STRING,
    district_id: INTEGER,
  }, {
    timestamps: false,
    tableName: 'house_bizcircle',
    freezeTableName: true,
  });

  HouseBizcircle.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HouseBizcircle.findOne({
      attributes: attributes,
      where : where,
    });
  }


  HouseBizcircle.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HouseBizcircle.findAll({
      attributes: attributes,
      where : where,
    });
  }

  HouseBizcircle.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };

    const { count, rows } =  await HouseBizcircle.findAndCountAll(condition);
    return { page, count, rows };
  }

  HouseBizcircle.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await HouseBizcircle.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  HouseBizcircle.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    HouseBizcircle.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return HouseBizcircle;

};
