'use strict';
const Service = require('egg').Service;
const APPID = 'wx4769ebba9b91f8ec';
const SECRET = '680440637b4e38c9b66529cfd5dc590e';

class WechatService extends Service {
  async getAccessToken() {
    const { ctx } = this;
    const url = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=' + APPID + '&secret=' + SECRET;

    // 先从redis中取
    let token = await this.app.memcache.get('wechat_course_accessToken');
    if (ctx.isEmpty(token)) {
      const resp = await ctx.helper.send_request(url, {}, { method: 'GET' });
      if (resp.status === 200 && !ctx.isEmpty(resp.data) && !ctx.isEmpty(resp.data.access_token)) {
        token = resp.data.access_token;
        await this.app.memcache.set('wechat_course_accessToken', token, resp.data.expires_in);
      }
    }

    return token;
  }

  async callbackAction() {
    const { ctx, app } = this;
    ctx.logger.info('course_wechat_receive: ' + JSON.stringify(ctx.request.body));
    await this.sendMsg(ctx.request.body);
  }

  async sendMsg(data) {
    const { ctx, app } = this;

    ctx.logger.info(111);
    if (ctx.isEmpty(data)) {
        return;
    }
    ctx.logger.info(222);
    //只有MsgType为miniprogrampage才发送
    // if (ctx.isEmpty(data.MsgType) || data.MsgType !== 'miniprogrampage') {
    //     return;
    // }

    let mediaId = await this.app.memcache.get('course_wechat_service_image_media_id');
    ctx.logger.info(mediaId);
    if (ctx.isEmpty(mediaId)) {
        const file = fs.createReadStream('http://r.51gjj.com/webpublic/images/20191023/xlQKaytyi19ya.jpg');
        const imageInfo = {
            type: 'image',
            media: file,
        };
        mediaId = await this.uploadTempMedia(imageInfo);
    }
    ctx.logger.info(mediaId);
    if (ctx.isEmpty(mediaId)) {
        return;
    }

    const token = await this.getAccessToken();
    const url = 'https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=' + token;
    const params = {
      access_token: token,
      touser: data.FromUserName,
      msgtype: 'image',
      image: { media_id: mediaId },
    };
    const resp = await ctx.helper.send_request(url, params, { method: 'POST' });
    ctx.logger.info('course_wechat_resp: ' + JSON.stringify(resp));
    return;
  }

  async getTempMedia(mediaId) {
      const {ctx} = this;
      const url = 'https://api.weixin.qq.com/cgi-bin/media/get';

      const image = await this.app.memcache.get('course_wechat_service_image');
      if (image) {
          return image;
      }

      const token = await this.getAccessToken();
      const params = {
          access_token: token,
          media_id: mediaId,
      };
      const resp = await ctx.helper.send_request(url, params, {method: 'GET'});

      let ret = '';
    if (resp.status === 200 && !ctx.isEmpty(resp.data) && resp.data.errCode === 0) {
        await this.app.memcache.set('course_wechat_service_image', resp.data.buffer, 72*3600);
        ret = resp.data.buffer;
    }

    return ret;
  }

  /*
  把媒体文件上传到微信服务器。目前仅支持图片。用于发送客服消息或被动回复用户消息。
  type: 'image',
  media: {
    contentType: 'image/png',
    value: Buffer
  }
  */
  async uploadTempMedia(data) {
    const {ctx, app} = this;
    if (ctx.isEmpty(data)) {
        return;
    }
    const token = await this.getAccessToken();
    const url = 'https://api.weixin.qq.com/cgi-bin/media/upload?access_token=' + token + '&type=image';
    const resp = await ctx.helper.send_request(url, data, {method: 'POST'});
    ctx.logger.info('course_wechat_uploadTempMedia_resp: ' + JSON.stringify(resp));
    
    let ret = '';
    if (resp.status === 200 && !ctx.isEmpty(resp.data) && resp.data.errCode === 0) {
        await this.app.memcache.set('course_wechat_service_image_media_id', resp.data.mediaId, 72*3600);
        ret = resp.data.mediaId;
    }

    return ret;
  }
}

module.exports = WechatService;
