'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, TEXT, DECIMAL } = app.Sequelize;

  const CourseUserOrder = app.classModel.define('course_user_order', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    order_no: STRING,
    user_uuid: STRING,
    class_id: INTEGER,
    pay: DECIMAL,
    pay_time: STRING,
    pay_result: TEXT,
    type: INTEGER,
    redeem: STRING,
    address: STRING,
    columns: TEXT,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_user_order',
  });

  return CourseUserOrder;

};
