'use strict';
const Service = require('egg').Service;
const R = require('ramda')
class ProductService extends Service {


    //通过 type=loan/credit 频道 option_ids 筛选项数组 all_product_ids
    // async getProductsByOptions(option_ids, all_product_ids = []) {

    //     const { ctx } = this;
    //     if (!Array.isArray(option_ids) || !option_ids || option_ids.length === 0) {
    //         return all_product_ids;
    //     }
    //     let product_ids = all_product_ids;
    //     for (let i in option_ids) {
    //         const option_id = option_ids[i];
    //         const products = await ctx.service.RecommendChannelProduct.all({ where: { option_id: option_id } });
    //         if (!products || products.length === 0 || Object.keys(products).length === 0) {
    //             continue;
    //         }
    //         const recommend_product_ids = R.pluck(products, 'product_id');
    //         product_ids = R.intersection(product_ids, recommend_product_ids);
    //     }

    //     return product_ids;
    // }

    //获取筛选项列表 带 product_id
    //return : [{"id":3,"title":"银行分类","description":"信用卡银行分类","_children":[{"id":12,"title":"招商银行","quality":["1"],"normal":["1"]},{"id":16,"title":"广发银行","quality":[],"normal":[]}]},{"id":4,"title":"主题分类","description":"信用卡主题分类","_children":[]},{"id":5,"title":"信用卡筛选项","description":"信用卡筛选项","_children":[]}]
    async getRecommendOptions(type = 'credit', keys = []) {

        const { ctx } = this;
        // const type = 'credit';
        // keys = ['loan_organization', 'loan_filter', 'credit_bank', 'credit_theme', 'credit_filter'];
        // console.info(keys);
        let classifies = await ctx.blockModel.RecommendChannelClassify.all({ where: { type: type, valid: 1, key: { $in: keys } } });
        // return classifies;
        classifies = R.project(['id', 'key', 'title', 'description'])(classifies);
        const classify_ids = R.pluck('id', classifies);
        let options = await ctx.blockModel.RecommendChannelOption.all({ where: { classify_id: { $in: classify_ids }, status: 'online', valid: 1 }, order: [['order', 'asc']] });
        options = R.project(['id', 'title', 'classify_id'])(options);
        const option_ids = R.pluck('id', options);
        let option_products = await ctx.blockModel.RecommendChannelProduct.all({ where: { option_id: { $in: option_ids }, valid: 1 }, order: [['order', 'asc']] });
        option_products = R.project(['option_id', 'product_id', 'type'])(option_products);
        let ret = [];
        for (let i in classifies) {
            let classify = classifies[i];
            const classify_id = classify.id;
            let temp_options = options.filter(option => parseInt(option.classify_id) === parseInt(classify_id));
            temp_options = R.project(['id', 'title'])(temp_options);
            for (let j in temp_options) {
                let temp_option = temp_options[j];
                const temp_option_id = temp_option.id;
                let temp_option_products = option_products.filter(v => parseInt(v.option_id) === parseInt(temp_option_id));
                temp_option_products = R.groupBy(v => { return v.type === 'quality' ? 'quality' : 'normal' })(temp_option_products);
                const quality_product_ids = R.pluck('product_id', temp_option_products.quality ? temp_option_products.quality : []);
                const normal_product_ids = R.pluck('product_id', temp_option_products.normal ? temp_option_products.normal : []);
                temp_options[j].quality = quality_product_ids;
                temp_options[j].normal = normal_product_ids;
            }

            classify._children = temp_options;
            ret.push(classify);
        }

        return ret;
    }

    //
    async getLoanChannelSuitOptions() {

        const { ctx } = this;
        const user_id = ctx.userId;
        if (user_id) {

        }

    }

}

module.exports = ProductService;
