'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/credit');
    const loginAuth = app.middleware.loginAuth({ type: 'new' });//登录中间件

    router.get('/history/:type', 'credit.order.getRecord');
    router.post('/order/pay', 'credit.order.payOrder');
    router.get('/order/pay/:order_id', 'credit.order.payOrder');
    router.post('third', '/order/wx_pay_notice', 'credit.order.WexinPayNotice');
    router.get('/order/check_pay/:order_id', 'credit.order.checkPay');
    router.get('/order/info/:order_id', 'credit.order.getOrderPayInfo');


    router.get('/home', 'credit.home.home');//首页


    //我的信用-黑名单报告
    router.get('/blacklist/report/:report_id', loginAuth, 'credit.blacklist.getBlacklistReport');//获取报告信息
    router.post('/blacklist/report', loginAuth, 'credit.blacklist.applyBlacklistReport');//查询个人黑名单报告
    router.get('/blacklist/init', loginAuth, 'credit.blacklist.blacklistInit');//进入黑名单检测页面
    router.post('/blacklist/verification_code', loginAuth, 'credit.blacklist.getBlacklistReportVerificationCode');//获取短信验证码


    //我的信用-个人通话风险
    router.get('/callrisk/report/:report_id',  'credit.callrisk.getReport');//获取报告信息
    router.post('/callrisk/report', 'credit.callrisk.applyCallriskReport');//查询个人通话信息
    router.get('/callrisk/init', 'credit.callrisk.callriskInit');//进入个人通话风险检测页面


};
