'use strict';

const Service = require('egg').Service;

class SearchHistoryService extends Service {

    async one(id) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/searchhistory/' + id, {}, { method: 'GET' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async edit(id, data) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/searchhistory/' + id, data, { method: 'PUT' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async delete(id) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/searchhistory/' + id, {}, { method: 'DELETE' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async all(data) {
        const { ctx } = this;
        const queryConditions = data.queryConditions;
        const sum = queryConditions.length;
        for (let i = 0; i < sum; i++) {
            if (queryConditions[i].key === 'userId' && queryConditions[i].value.length === 0) {
                queryConditions[i].value = true;
                queryConditions[i].operator = 'isnull';
            }
        }
        data.queryConditions = queryConditions;
        if (Object.keys(data.orderConditions).length === 0) {
            data.orderConditions = [{
                key: 'createdAt',
                orderSequence: 'desc',
            }];
        }

        ctx.logger.info('get_newHouse_filter: ' + JSON.stringify(data));

        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/searchhistory/list', data, { method: 'POST' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async add(data) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/searchhistory/', data, { method: 'POST' });
        if (result.status !== 201) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

}

module.exports = SearchHistoryService;
