'use strict';

const Controller = require('egg').Controller;

class UserController extends Controller {
    /**
     * 获取用户的手机号
     */
    async userAuth() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        let rule = {
            code: { type: 'string', required: true },
            iv: { type: 'string', required: true },
            encryptedData: { type: 'string', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.user.userAuth(inputParams);
        ctx.success(ret);
    }

}

module.exports = UserController;
