'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM, TEXT } = app.Sequelize;

  const CourseArticle = app.classModel.define('course_article', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    type: INTEGER,
    cat_id: INTEGER,
    title: STRING,
    description: STRING,
    content: TEXT,
    image: STRING,
    source: STRING,
    like_count: INTEGER,
    read_count: INTEGER,
    sort: INTEGER,
    status: ENUM('offline', 'online'),
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_article',
  });

  return CourseArticle;

};
