'use strict';
module.exports = app => {
    const { INTEGER, TEXT } = app.Sequelize;

    const HousePriceTrend = app.blockModel.define('house_price_trend', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        trend_json: {
            type: TEXT,
            allowNull: true,
            field: 'trend_json',
            get() {
                const trend_json = this.getDataValue('trend_json');
                if (trend_json) {
                    try {
                        return JSON.parse(trend_json);
                    } catch (error) {
                        return [];
                    }
                }
                return [];
            },
        },
    }, {
            timestamps: false,
            tableName: 'house_price_trend',
            freezeTableName: true,
        });

    HousePriceTrend.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HousePriceTrend.findOne({
            attributes: attributes,
            where: where,
        });
    }


    HousePriceTrend.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HousePriceTrend.findAll({
            attributes: attributes,
            where: where,
        });
    }

    HousePriceTrend.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };

        const { count, rows } = await HousePriceTrend.findAndCountAll(condition);
        return { page, count, rows };
    }

    HousePriceTrend.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await HousePriceTrend.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            ctx.status = 500;
            throw (error);
        }
    }

    HousePriceTrend.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        HousePriceTrend.update(params, {
            where: where
        }).catch(e => res.json({ status: 500, error: e }));
    }

    return HousePriceTrend;

};
