
'use strict';

const Service = require('egg').Service;
const moment = require('moment');

class HotQuestionPutService extends Service {

    /**
     * 添加预约信息
     * @param {object} inputParams 
     */
    async addQuestion(inputParams) {
        const { ctx } = this;
        let data = {
            user_id: ctx.userId,
            app_user_id: ctx.appUserId,
            app_id: ctx.appId,
            app_type_id: ctx.appTypeId,
            question: inputParams.question,
            city: Number(inputParams.city_code),
            status: 'wait',
        };
        let retId = await ctx.realestateModel.HotQuestionPut.add(data);
        return { id: retId };
    }


    /**
     * 根据条件获取热门问题列表
     * 默认城市北京110000
     * 默认取20条
     * @param {object} condition 
     */
    async questionList(condition) {
        const { ctx } = this;
        let filter = {
            attributes: ['id', 'question'],
            page: condition.page || 1,
            limit: condition.limit || 20,
            where: {
                city: condition.city_code || 110000,
                status: 'pass',
            },
            order: [['created_at', 'desc']]
        }
        if (condition.key_word) {//关键词搜索 模糊查询
            //增加搜索历史
            // let addHistory = {
            //     type: 1,
            //     key_word: condition.name
            // };
            // await ctx.service.house.v2.searchHistory.addSearchHistory(addHistory);
            filter.where.question = { $like: '%' + condition.key_word + '%' }
        }
        let res = await ctx.realestateModel.HotQuestionPut.list(filter);
        let ret = {
            count: res.count,
            results: res.rows
        }
        return ret;
    }

    /**
     * 问题详情
     * @param {*} condition 
     */
    async questionDetail(condition) {
        const { ctx } = this;
        //问题内容
        let filter = {
            attributes: ['question'],
            where: {
                id: Number(condition.id),
                status: "pass"
            }
        }
        let question = await ctx.realestateModel.HotQuestionPut.one(filter);
        //回答的列表
        let answerFliter = {
            page: Number(condition.page) || 1,
            limit: Number(condition.limit) || 10,
            question_id: Number(condition.id),
        }
        let answerLsit = await ctx.service.house.v2.hotQuestionAnswer.answerList(answerFliter);
        let ret = {
            question: question.question,
            answerList: answerLsit
        }
        return ret;
    }


    async mineQuestion(condition) {
        const { ctx } = this;
        let filter = {
            page: condition.page || 1,
            limit: condition.limit || 10,
            attributes: ['id', 'question', 'status'],
            where: {
                user_id: ctx.userId,
            },
            order: [['created_at', 'desc']]
        }
        let res = await ctx.realestateModel.HotQuestionPut.list(filter);
        let ret = {
            results: res.rows,
            count: res.count
        }
        return ret;
    }






}

module.exports = HotQuestionPutService;
