'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;

  const CourseV5Video = app.classModel.define('course_v5_video', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    class_id: INTEGER,
    title: STRING,
    time: STRING,
    cover_image: STRING,
    url: STRING,
    is_free: INTEGER,
    status: INTEGER,
    is_deleted: INTEGER,
    sort: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_video',
  });

  return CourseV5Video;

};
