'use strict';

module.exports = (options, app) => {

    return async function (ctx, next) {

        const uuid = ctx.headers.uuid;
        const key = 'course_user_session_' + uuid;
        const auth_info = await ctx.app.memcache.get(key);
        if (!auth_info) {
            // await next();
            // return;
            ctx.failed('login auth error');
        }
        const openid = auth_info.openid;
        const user_uuid = auth_info.user_uuid;
        const auth_token = ctx.headers.auth_token;
        if (ctx.helper.md5(openid + uuid + 'jbwl') != auth_token) {
            ctx.failed('login auth error');
        }
        // console.info('11111111111111111111111111111111');
        // console.info(auth_info);
        ctx.setUserUuid(user_uuid);

        await next();
    };
};
