'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/house');
    const loginAuth = app.middleware.loginAuth({ type: 'new' });//登录中间件

    router.get('/tool/:house_style/:area_code/:level', 'house.tool.getMapPoint');//购房计划地图点位
    router.post('/tool/plan', 'house.tool.generateBuyHousePlan');//生成购房计划
    router.get('/tool/:type/:area_code', 'house.tool.getHousePriceFeature');//房价指数 房价涨跌 购房资格、贷款额度问答
    router.get('/tool/calculate_price', 'house.tool.calculateHousePrice2');//房产估价
    router.get('/tool/qfang_area_list', 'house.tool.getQFangAreaList');//房产估价

    //租房
    router.get('/rental_house/home', 'house.rentalHouse.home');//租房首页信息
    router.get('/options/:city_code', 'house.options.getOptions');//筛选项信息
    router.get('/rental_house/list', 'house.rentalHouse.getRentalHouses');//租房列表
    router.post('/rental_house/list', 'house.rentalHouse.getRentalHouses');//租房列表
    router.get('/rental_house/info/:rental_house_id', 'house.rentalHouse.getRentalHouse');//租房列表


    //新房
    router.post('/new_house/list', 'house.newHouse.getNewHouseList');//根据条件筛选列表
    router.get('/new_house/:id', 'house.newHouse.getNewHouse');//新房具体信息
    router.get('/new_house_type/:id', 'house.newHouse.getNewHouseType');//新房户型
    router.get('/new_house/options/:city_code', 'house.options.getNewHouseOptions');//筛选项信息

    //预约
    router.post('/order', loginAuth, 'house.order.addOrder');//预约
    router.get('/order/list', loginAuth, 'house.order.getOrderList');//预约列表

    //收藏
    router.post('/collection', loginAuth, 'house.collection.addCollection');//收藏
    router.get('/collection/list', loginAuth, 'house.collection.getCollectionList');//收藏列表

    //搜索历史
    router.get('/search_history', 'house.searchHistory.getsearchHistory');//收藏列表
    router.put('/search_history/:type', 'house.searchHistory.cleanSearchHistory');//用户点击清除搜索记录

    //足迹
    router.get('/foot_print/list', 'house.footPrint.getFootPrintList');//用户浏览记录列表

    //我的
    router.get('/mine', 'house.mine.getMineInfo');//获取用户的头像昵称和关注等信息



};
