'use strict';

const Controller = require('egg').Controller;

class CallriskController extends Controller {

    /**
     * 获取黑名单报告
     */
    async getReport() {

        const { ctx } = this;
        const report_id = ctx.params.report_id;
        let ret = await ctx.service.credit.callrisk.getReport(report_id);
        ctx.success(ret);

    }

    async queryCallRisk() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const { real_name, id_card, phone, password } = input_params;

        if (ctx.helper.verify_real_name(real_name) !== 1) {
            ctx.failed('姓名输入有误，请校验后输入');
        }
        if (!ctx.helper.verify_id_card(id_card)) {
            ctx.failed('身份证输入有误，请校验后输入');
        }
        if (!ctx.helper.isPhoneNumber(phone)) {
            ctx.failed('手机号输入有误，请校验后输入');
        }

        //TODO 三要素校验 调用数据服务接口





    }


}

module.exports = CallriskController;
