'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM } = app.Sequelize;

  const CourseOnlineType = app.classModel.define('course_online_type', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    name: STRING,
    status: ENUM('offline', 'online'),
    is_deleted: INTEGER,
    sort: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_online_type',
  });

  CourseOnlineType.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await CourseOnlineType.findOne({
      attributes,
      where,
    });
  };

  CourseOnlineType.all = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const order = data.order ? data.order : [];
    return await CourseOnlineType.findAll({
      attributes,
      where,
      order,
    });
  };

  CourseOnlineType.list = async (data = {}) => {
    const limit = data.limit ? Number(data.limit) : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where,
      order,
      attributes,
    };
    const { count, rows } = await CourseOnlineType.findAndCountAll(condition);
    return { page, count, rows };
  };

  CourseOnlineType.add = async data => {
    try {
      // 返回promise对象实力 instance
      const res = await CourseOnlineType.create(data);
      // 从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      throw (error);
    }
  };

  CourseOnlineType.edit = async data => {
    const where = data.where;
    const params = data.params;
    try {
      const res = await CourseOnlineType.update(params, { where });
      return res;
    } catch (error) {
      throw (error);
    }
  };

  return CourseOnlineType;

};
