'use strict';

const Controller = require('egg').Controller;

class LocationController extends Controller {

    /**
     * 筛选项
     */
    async getAddress() {

        const { ctx } = this;
        const { lat, lng } = ctx.request.body;
        if (!lat || !lng) {
            ctx.failed('error lat lng');
        }
        const location_ret = await ctx.service.course.lbs.getLBSLocation({ lat, lng });
        let address = '获取位置信息失败';
        if (location_ret.result.formatted_addresses && location_ret.result.formatted_addresses.recommend) {
            address = location_ret.result.formatted_addresses.recommend;
        }

        ctx.success({ result: address });
    }

}

module.exports = LocationController;
