'use strict';

const Controller = require('egg').Controller;

class BackController extends Controller {
  // 登录
  async login() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.account)) {
      ctx.failed('account is empty');
    }
    if (ctx.isEmpty(params) || ctx.isEmpty(params.password)) {
      ctx.failed('password is empty');
    }

    const ret = await service.course.back.login(params);
    ctx.success(ret);
  }


  // 获取菜单
  async getMenuList() {
    const { ctx, service } = this;

    const ret = await service.course.back.getMenuList();
    ctx.success(ret);
  }
}

module.exports = BackController;
