'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, DECIMAL, TEXT } = app.Sequelize;

  const CourseV5Class = app.classModel.define('course_v5_class', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    institution_id: INTEGER,
    name: STRING,
    logo: STRING,
    age: STRING,
    price: STRING,
    filter_price: DECIMAL,
    price_type: INTEGER,
    mode: INTEGER,
    time: INTEGER,
    class_amount: INTEGER,
    multi_classes: INTEGER,
    cycle: STRING,
    channel: TEXT,
    description: TEXT,
    button_style: INTEGER,
    button_text: STRING,
    button_type: INTEGER,
    button_sub_text: STRING,
    button_url: STRING,
    button_pay_text: STRING,
    top_price: STRING,
    pay_price: DECIMAL,
    sort: INTEGER,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_class',
  });

  return CourseV5Class;

};
