'use strict';

const Controller = require('egg').Controller;

class CollectionController extends Controller {
    /**
     * 关注
     */
    async addCollection() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            id: {
                type: 'integer',
                required: true,
            },
            type: {
                type: 'integer',
                required: true,
            }
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.house.collection.addCollection(inputParams);
        ctx.success(ret);
    }

    /**
     * 获取关注列表
     */
    async getCollectionList() {
        const { ctx } = this;
        let ret = await ctx.service.house.collection.getCollectionList();
        ctx.success(ret);
    }


    async unCollection(){
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            id: {
                type: 'integer',
                required: true,
            },
            type: {
                type: 'integer',
                required: true,
            }
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.house.collection.unCollection(inputParams);
        ctx.success(ret);
    }

}

module.exports = CollectionController;
