'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, TEXT, DECIMAL } = app.Sequelize;
    const AbroadHouse = app.realestateModel.define('abroad_house', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        name: {
            type: STRING,
            allowNull: true
        },
        images: {
            type: TEXT,
            allowNull: true
        },
        tags: {
            type: STRING,
            allowNull: true
        },
        total_price: {
            type: DECIMAL,
            allowNull: true
        },
        url: {
            type: STRING,
            allowNull: true
        },
        order: {
            type: INTEGER,
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        status: {
            type: STRING,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },

    }, {
        timestamps: false,
        tableName: 'abroad_house',
    });

    
    AbroadHouse.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await AbroadHouse.findOne({
            attributes: attributes,
            where: where,
        });
    }


    AbroadHouse.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await AbroadHouse.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    AbroadHouse.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await AbroadHouse.findAndCountAll(condition);
        return { page, count, rows };
    }

    AbroadHouse.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await AbroadHouse.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    AbroadHouse.edit = async (data) => {

        const where = data.where;
        const params = data.params;
        try {
            return await AbroadHouse.update(params, { where: where })
        } catch (error) {
            throw (error);
        }
    }

    return AbroadHouse;

};
