'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE } = app.Sequelize;

    const SysUser = app.gjjModel.define('sys_suer', {
        sid: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        passport: {
            type: STRING,
            allowNull: false
        },
        yys_cid: {
            type: INTEGER,
            allowNull: true
        },
        cv: {
            type: STRING,
            allowNull: true
        },
        ov: {
            type: STRING,
            allowNull: false
        },
        place_cid: {
            type: INTEGER,
            allowNull: false
        },
        apns: {
            type: STRING,
            allowNull: true
        },
        phone: {
            type: STRING,
            allowNull: true
        },
        time: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        regtime: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('regtime');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        read_time: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('read_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'sys_user',
        });

    SysUser.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await SysUser.findOne({
            attributes: attributes,
            where: where,
        });
    }

    return SysUser;
};

