'use strict';

module.exports = app => {
  const router = app.router.namespace(app.config.projectRootPath + '/course');
  const loginAuth = app.middleware.loginAuth({ type: 'new' });// 登录中间件
  const miniAuth = app.middleware.miniAuth();// 因为不跟现有的用户中心系统，所以使用单独的登录中间件

  router.get('third', '/options', 'course.option.getOptions');// 筛选项
  router.post('third', '/address', miniAuth, 'course.location.getAddress');// 根据经纬度或ip获取地理位置信息
  router.post('third', '/institutions', miniAuth, 'course.institution.institutionList');// 机构列表
  router.get('third', '/institutions', miniAuth, 'course.institution.institutionList');// 机构列表
  router.get('third', '/institution/:institution_id/:area_id', miniAuth, 'course.institution.institutionInfo');// 机构详情
  router.post('third', '/classes', miniAuth, 'course.institution.classList');// 课程列表
  router.get('third', '/classes', miniAuth, 'course.institution.classList');// 课程列表
  router.get('third', '/class/:class_id', miniAuth, 'course.institution.classInfo');// 课程详情
  router.post('third', '/teachers', miniAuth, 'course.institution.teacherList');// 老师列表
  router.get('third', '/teachers', miniAuth, 'course.institution.teacherList');// 老师详情
  router.get('third', '/teacher/:teacher_id', miniAuth, 'course.institution.teacherInfo');// 老师详情

  router.post('third', '/user/auth', 'course.user.auth');// 微信授权登录
  router.post('third', '/user/register_user', miniAuth, 'course.user.registerUserInfo');// 授权后注册用户

  router.get('third', '/user/baby', miniAuth, 'course.user.getBabyInfo');// 获取baby信息
  router.post('third', '/user/baby', miniAuth, 'course.user.saveBabyInfo');// 保存baby信息
  router.delete('third', '/user/baby', miniAuth, 'course.user.delBabyInfo');// 删除baby信息

  router.get('third', '/user/collection/institution', miniAuth, 'course.user.getCollectInstitutions');// 收藏的机构列表
  router.post('third', '/user/collection/institution', miniAuth, 'course.user.collectInstitution');// 收藏机构
  router.delete('third', '/user/collection/institution', miniAuth, 'course.user.delCollectInstitution');// 取消收藏机构

  router.get('third', '/wechat/callbackAction', 'course.wechat.check');
  router.post('third', '/wechat/callbackAction', miniAuth, 'course.wechat.callbackAction');
};
