'use strict';

const Controller = require('egg').Controller;

class OptionController extends Controller {
  async getOptions() {

    const { ctx } = this;
    const ret = await ctx.service.course.v5.option.getOptions();

    ctx.success(ret);
  }

  async getBannerList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;
    if (ctx.isEmpty(queryParams.alias)) {
      ctx.failed('alias is empty');
    }
    const ret = await service.course.v5.option.getBannerList(queryParams.alias);

    ctx.success(ret);
  }

  // 获取分类列表
  async getCategoryList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    const ret = await service.course.v5.option.getCategoryList(queryParams);
    ctx.success(ret);
  }

  // 获取反馈类型列表
  async getFeedbackTypeList() {
    const { ctx, service } = this;
    const ret = await service.course.v5.option.getFeedbackTypeList();

    ctx.success(ret);
  }

  // 上传反馈内容
  async addFeedback() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.type)) {
      ctx.failed('type is empty');
    }
    if (ctx.isEmpty(params) || ctx.isEmpty(params.content)) {
      ctx.failed('content is empty');
    }

    const ret = await service.course.v5.option.addFeedback(params);
    ctx.success(ret);
  }

  // 获取分类年龄提示
  async getCategoryTip() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.cat_id)) {
      ctx.failed('cat_id is empty');
    }

    const ret = await service.course.v5.option.getCategoryTip(queryParams);
    ctx.success(ret);
  }

  // 填写问卷
  async addQuestionnaire() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.cat_id)) {
      ctx.failed('cat_id is empty');
    }

    if (ctx.isEmpty(params) || ctx.isEmpty(params.answer_1)) {
      ctx.failed('answer_1 is empty');
    }

    if (ctx.isEmpty(params) || ctx.isEmpty(params.answer_2)) {
      ctx.failed('answer_2 is empty');
    }

    if (ctx.isEmpty(params) || ctx.isEmpty(params.answer_3)) {
      ctx.failed('answer_3 is empty');
    }

    const ret = await service.course.v5.option.addQuestionnaire(params);
    ctx.success(ret);
  }

  // 获取问卷
  async getQuestionnaire() {
    const { ctx, service } = this;

    const ret = await service.course.v5.option.getQuestionnaire();
    ctx.success(ret);
  }


  // 保存渠道小程序码
  async addUnlimitedCodeByChannel() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.channel)) {
      ctx.failed('channel is empty');
    }
    if (ctx.isEmpty(params) || ctx.isEmpty(params.image)) {
      ctx.failed('image is empty');
    }

    const ret = await service.course.v5.option.addUnlimitedCodeByChannel(params);
    ctx.success(ret);
  }

  // 获取渠道小程序码
  async getUnlimitedCodeByChannel() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.channel)) {
      ctx.failed('channel is empty');
    }

    const ret = await service.course.v5.option.getUnlimitedCodeByChannel(queryParams);
    ctx.success(ret);
  }


  // 获取配置项
  async getSetting() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.key)) {
      ctx.failed('key is empty');
    }

    const ret = await service.course.v5.option.getSetting(queryParams);
    ctx.success(ret);
  }
}

module.exports = OptionController;
