'use strict';

const Controller = require('egg').Controller;

class InstitutionSubController extends Controller {

  /**
     * 机构列表
     */
  async institutionList() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    const ret = await ctx.service.course.institutionSub.getInstitutions(inputParams);

    ctx.success(ret);
  }

  /**
     * 机构详情
     */
  async institutionInfo() {

    const { ctx } = this;
    let inputParams = ctx.params;
    const query = ctx.query;
    inputParams = Object.assign(inputParams, query);
    const result = await ctx.service.course.institutionSub.getInstitution(inputParams);

    ctx.success({ result });
  }

  /**
     * 课程列表
     */
  async classList() {

    const { ctx } = this;
    const inputParams = ctx.request.body;
    const results = await ctx.service.course.institutionSub.getClasses(inputParams);

    ctx.success({ results });
  }

  /**
     * 课程详情
     */
  async classInfo() {

    const { ctx } = this;
    const class_id = ctx.params.class_id;
    if (!class_id) {
      ctx.failed('error class_id');
    }
    const ret = await ctx.service.course.institutionSub.getClass(class_id);

    ctx.success(ret);
  }

  /**
     * 老师列表
     */
  async teacherList() {

    const { ctx } = this;
    const inputParams = ctx.request.body;
    const ret = await ctx.service.course.institutionSub.getTeachers(inputParams);

    ctx.success(ret);
  }

  /**
     * 老师详情
     */
  async teacherInfo() {

    const { ctx } = this;
    const teacher_id = ctx.params.teacher_id;
    if (!teacher_id) {
      ctx.failed('error teacher_id');
    }
    const ret = await ctx.service.course.institutionSub.getTeacher(teacher_id);

    ctx.success(ret);
  }

  // 获取分类
  async getCats() {
    const { ctx } = this;

    const ret = await ctx.service.course.institutionSub.getCats();

    ctx.success(ret);
  }

  // 搜索
  async search() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    const ret = await ctx.service.course.institutionSub.search(inputParams);

    ctx.success(ret);
  }
}

module.exports = InstitutionSubController;
