
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class ApplyService extends Service {

    /**
     * 从数据接口获取用户的黑名单报告信息
     * @param {*} inputParams 
     */
    async applyBlacklist(inputParams) {
        const { ctx } = this;
        let params = {
            sign: "",
            signParams: {
                appKey: this.config.BLACKLIST_APPLY_APPKEY,
                timestamp: String(new Date().getTime()),
            },
            phone: inputParams.phone,
            name: inputParams.name,
            idcard: inputParams.id_card
        }
        params.sign = await ctx.service.credit.common.sign(params.signParams, this.config.BLACKLIST_APPLY_APPSECRET);
        ctx.logger.info(params);
        let url = this.config.BLACKLIST_APPLY_URL;
        let result = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info(result);
        ctx.logger.info(result.data);
        ctx.logger.info(result.data.data.blackList);

        if (result.status != 200) {
            ctx.failed('数据获取接口异常');
        }
        let applyData = {
            type: 1,
            user_id: ctx.userId,
            app_user_id: ctx.appUserId,
            app_id: ctx.appId,
            app_type_id: ctx.appTypeId,
            name: inputParams.name,
            phone: inputParams.dataphone,
            id_card: inputParams.id_card,
            timestamp: params.signParams.timestamp,
            appkey: this.config.BLACKLIST_APPLY_APPKEY,
            sign: params.sign,
            r_code: result.data.code,
            r_msg: result.data.msg,
            r_order_id: result.data.data.order_id,
        }
        let applyId = await ctx.prometheusModel.CreditApply.create(applyData);
        if (result.data.code === 0) {
            let blacklistInfo = result.data.data.blackList;
            let reportData = {
                name: inputParams.name,
                id_card: inputParams.id_card,
                phone: inputParams.phone,
                age: '',
                city: '',
                blacklist_of_internet_loans: blacklistInfo.pre_loan_risk.blacklist_of_internet_loans,
                blacklist_of_court_dishonesty: blacklistInfo.pre_loan_risk.blacklist_of_court_dishonesty,
                blacklist_of_industry: blacklistInfo.pre_loan_risk.blacklist_of_industry,
                blacklist_of_ds_industry: blacklistInfo.pre_loan_risk.blacklist_of_ds_industry,
                blacklist_of_bx_industry: blacklistInfo.pre_loan_risk.blacklist_of_bx_industry,
                blacklist_of_zc_industry: blacklistInfo.pre_loan_risk.blacklist_of_zc_industry,
                blacklist_of_zf_industry: blacklistInfo.pre_loan_risk.blacklist_of_zf_industry,
                blacklist_of_jd_industry: blacklistInfo.pre_loan_risk.blacklist_of_jd_industry,
                reg_count_1month: blacklistInfo.long_lending_risk.reg_count_1month,
                reg_count_3month: blacklistInfo.long_lending_risk.reg_count_3month,
                reg_count_6month: blacklistInfo.long_lending_risk.reg_count_6month,
                consume_reg_count_1month: blacklistInfo.long_lending_risk.consume_reg_count_1month,
                consume_reg_count_3month: blacklistInfo.long_lending_risk.consume_reg_count_3month,
                consume_reg_count_6month: blacklistInfo.long_lending_risk.consume_reg_count_6month,
                loan_reg_count_1month: blacklistInfo.long_lending_risk.loan_reg_count_1month,
                loan_reg_count_3month: blacklistInfo.long_lending_risk.loan_reg_count_3month,
                loan_reg_count_6month: blacklistInfo.long_lending_risk.loan_reg_count_6month,
                consume_reg_platform_count_1month: blacklistInfo.long_lending_risk.consume_reg_platform_count_1month,
                consume_reg_platform_count_3month: blacklistInfo.long_lending_risk.consume_reg_platform_count_3month,
                consume_reg_platform_count_6month: blacklistInfo.long_lending_risk.consume_reg_platform_count_6month,
                loan_reg_platform_count_1month: blacklistInfo.long_lending_risk.loan_reg_platform_count_1month,
                loan_reg_platform_count_3month: blacklistInfo.long_lending_risk.loan_reg_platform_count_3month,
                loan_reg_platform_count_6month: blacklistInfo.long_lending_risk.loan_reg_platform_count_6month,
                reg_platform_count_1month: blacklistInfo.long_lending_risk.reg_platform_count_1month,
                reg_platform_count_3month: blacklistInfo.long_lending_risk.reg_platform_count_3month,
                reg_platform_count_6month: blacklistInfo.long_lending_risk.reg_platform_count_6month,
                credit_count_1month: blacklistInfo.long_lending_risk.credit_count_1month,
                credit_count_3month: blacklistInfo.long_lending_risk.credit_count_3month,
                credit_count_6month: blacklistInfo.long_lending_risk.credit_count_6month,
                credit_amount_1month: blacklistInfo.long_lending_risk.credit_amount_1month,
                credit_amount_3month: blacklistInfo.long_lending_risk.credit_amount_3month,
                credit_amount_6month: blacklistInfo.long_lending_risk.credit_amount_6month,
                credit_closed_count_1month: blacklistInfo.long_lending_risk.credit_closed_count_1month,
                credit_closed_count_3month: blacklistInfo.long_lending_risk.credit_closed_count_3month,
                credit_closed_count_6month: blacklistInfo.long_lending_risk.credit_closed_count_6month,
                credit_closed_amount_1month: blacklistInfo.long_lending_risk.credit_closed_amount_1month,
                credit_closed_amount_3month: blacklistInfo.long_lending_risk.credit_closed_amount_3month,
                credit_closed_amount_6month: blacklistInfo.long_lending_risk.credit_closed_amount_6month,
                consume_credit_count_1month: blacklistInfo.long_lending_risk.consume_credit_count_1month,
                consume_credit_count_3month: blacklistInfo.long_lending_risk.consume_credit_count_3month,
                consume_credit_count_6month: blacklistInfo.long_lending_risk.consume_credit_count_6month,
                loan_credit_count_1month: blacklistInfo.long_lending_risk.loan_credit_count_1month,
                loan_credit_count_3month: blacklistInfo.long_lending_risk.loan_credit_count_3month,
                loan_credit_count_6month: blacklistInfo.long_lending_risk.loan_credit_count_6month,
                consume_credit_platform_count_1month: blacklistInfo.long_lending_risk.consume_credit_platform_count_1month,
                consume_credit_platform_count_3month: blacklistInfo.long_lending_risk.consume_credit_platform_count_3month,
                consume_credit_platform_count_6month: blacklistInfo.long_lending_risk.consume_credit_platform_count_6month,
                loan_credit_platform_count_1month: blacklistInfo.long_lending_risk.loan_credit_platform_count_1month,
                loan_credit_platform_count_3month: blacklistInfo.long_lending_risk.loan_credit_platform_count_3month,
                loan_credit_platform_count_6month: blacklistInfo.long_lending_risk.loan_credit_platform_count_6month,
                credit_platform_count_1month: blacklistInfo.long_lending_risk.credit_platform_count_1month,
                credit_platform_count_3month: blacklistInfo.long_lending_risk.credit_platform_count_3month,
                credit_platform_count_6month: blacklistInfo.long_lending_risk.credit_platform_count_6month,
                id_card_relevant_mobilephone_count: blacklistInfo.identity_related_risk.id_card_relevant_mobilephone_count,
                id_card_relevant_device_count: blacklistInfo.identity_related_risk.id_card_relevant_device_count,
                mobilephone_relevant_id_card_count: blacklistInfo.identity_related_risk.mobilephone_relevant_id_card_count,
                relevant_loan_app_count_6month: blacklistInfo.related_app.relevant_loan_app_count_6month,
                relevant_gamble_app_count_6month: blacklistInfo.related_app.relevant_gamble_app_count_6month,
                relevant_ip_app_count_6month: blacklistInfo.related_app.relevant_ip_app_count_6month,
                relevant_other_app_count_6month: blacklistInfo.related_app.relevant_other_app_count_6month,
                overdue: JSON.stringify(blacklistInfo.overdue_analysis)
            }
            let reportId = await ctx.prometheusModel.CreditBlacklistReport.create(reportData);
        }


    }



}

module.exports = ApplyService;
