
'use strict';

const moment = require('moment');

module.exports = app => {

    const { STRING, INTEGER, DATE, DECIMAL, ENUM } = app.Sequelize;

    const RentalHouseType = app.realestateModel.define('rental_house_type', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        name: {
            type: STRING,
            allowNull: true
        },
        rental_house_id: {
            type: INTEGER,
            allowNull: false
        },
        type: {
            type: INTEGER,
            allowNull: true
        },
        price: {
            type: DECIMAL,
            allowNull: true
        },
        discount: {
            type: DECIMAL,
            allowNull: true
        },
        area: {
            type: DECIMAL,
            allowNull: true
        },
        remark: {
            type: STRING,
            allowNull: true
        },
        status: {
            type: ENUM('online', 'offline'),
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        deleted_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        created_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'rental_house_type',
        });


    RentalHouseType.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await RentalHouseType.findOne({
            attributes: attributes,
            where: where,
        });
    }

    RentalHouseType.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await RentalHouseType.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    RentalHouseType.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await RentalHouseType.findAndCountAll(condition);
        return { page, count, rows };
    }

    RentalHouseType.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await RentalHouseType.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    RentalHouseType.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            return res = await RentalHouseType.update(params, { where: where })
        } catch (error) {
            throw (error);
        }
    }

    return RentalHouseType;

};