'use strict';

const Controller = require('egg').Controller;

class InstitutionController extends Controller {

    /**
     * 机构列表
     */
    async institutionList() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const results = await ctx.service.course.institution.getInstitutions(input_params);

        ctx.success({ results });
    }

    /**
     * 机构详情
     */
    async institutionInfo() {

        const { ctx } = this;
        let input_params = ctx.params;
        const query = ctx.query;
        input_params = Object.assign(input_params, query);
        const result = await ctx.service.course.institution.getInstitution(input_params);

        ctx.success({ result });
    }

    /**
     * 课程列表
     */
    async classList() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const results = await ctx.service.course.institution.getClasses(input_params);

        ctx.success({ results });
    }

    /**
     * 课程详情
     */
    async classInfo() {

        const { ctx } = this;
        const class_id = ctx.params.class_id;
        if (!class_id) {
            ctx.failed('error class_id');
        }
        let ret = await ctx.service.course.institution.getClass(class_id);

        ctx.success(ret);
    }

    /**
     * 老师列表
     */
    async teacherList() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        let ret = await ctx.service.course.institution.getTeachers(input_params);

        ctx.success(ret);
    }

    /**
     * 老师详情
     */
    async teacherInfo() {

        const { ctx } = this;
        const teacher_id = ctx.params.teacher_id;
        if (!teacher_id) {
            ctx.failed('error teacher_id');
        }
        let ret = await ctx.service.course.institution.getTeacher(teacher_id);

        ctx.success(ret);
    }



}

module.exports = InstitutionController;
