'use strict';

const Controller = require('egg').Controller;

class Export20190425 extends Controller {
    /**
     * 关注
     */
    async exportHouseImages() {
        const { ctx } = this;
        const house_images = await ctx.realestateModel.HouseImage.findAll();
        let count = 0;
        for (let i in house_images) {
            const item = house_images[i];
            const add_data = {
                path: 'https://r.51gjj.com/' + item.path,
                type: item.type,
                connectId: item.connect_id,
                remark: item.remark,
                state: 1,
                description: '',
            };
            const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/houseimage', add_data, { method: 'POST' });
            if (result.status === 201) count++;
        }
        ctx.success(count);

    }

    async exportResidential() {

        const { ctx } = this;
        const residentials = await ctx.realestateModel.Residential.findAll();
        let count = 0;
        let result;
        for (let i in residentials) {
            const residential = residentials[i];
            const add_data = {
                name: residential.name,
                province: residential.province,
                city: residential.city,
                county: residential.county,
                region: residential.region,
                propertyRightYears: residential.property_right_years,
                propertyFee: residential.property_fee,
                propertyCompany: residential.property_company,
                heatSupplyType: residential.heat_supply_type,
                waterSupplyType: residential.water_suppler_type,
                powerSupplyType: residential.power_suppler_type,
                landArea: residential.land_area,
                houseArea: residential.house_area,
                areaRatio: residential.area_ratio,
                greenRatio: residential.green_ratio,
                archType: residential.arch_type,
                nearBy: residential.nearby,
                state: 1,
                remark: '',
            }
            result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/residential', add_data, { method: 'POST' });
            if (result.status === 201) {
                count++;
            }
            // if(count === 1) break;
        }
        ctx.success(count);;
    }

}

module.exports = Export20190425;
