
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');


class NewsService extends Service {

    /**
     * 资讯标签列表
     * @param {*} condition 
     */
    async getList() {
        const { ctx } = this;

        let filter = {
            attributes: ['tag'],
            where: {
                valid: 1,
                status: 'online',
            },
        }
        let list = await ctx.realestateModel.CdNewsTag.findAll(filter);
        let ret = _.map(list, 'tag')
        return ret;
    }

}

module.exports = NewsService;
