'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

    const CourseClass = app.classModel.define('course_class_v1', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        institution_id: INTEGER,
        name: STRING,
        // image: STRING,
        price: DECIMAL,
        min_age: INTEGER,
        max_age: INTEGER,
        suit_base: STRING,
        type: STRING,
        class_system: STRING,
        class_period: STRING,
        class_time: STRING,
        student_count: STRING,
        point: STRING,
        description: STRING,
        status: ENUM('offline', 'online'),
        is_deleted: INTEGER,
        created_time: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'course_class_v1',
        });

    CourseClass.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await CourseClass.findOne({
            attributes: attributes,
            where: where,
        });
    }

    CourseClass.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await CourseClass.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    CourseClass.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await CourseClass.findAndCountAll(condition);
        return { page, count, rows };
    }

    CourseClass.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await CourseClass.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    CourseClass.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            const res = await CourseClass.update(params, { where: where })
            return res;
        } catch (error) {
            throw (error);
        }
    }

    return CourseClass;

};