
'use strict';

const Service = require('egg').Service;
const R = require('ramda');
const moment = require('moment');
class InstitutionService extends Service {

    /**
     * 机构详情页
     */
    async getInstitution({ institution_id, area_id }) {

        const { ctx } = this;
        const institution = await ctx.prometheusModel.CourseInstitution.one({ where: { id: institution_id } });
        const teachers = await this.getInstitutionTeachers({ institution_id, limit: 6 });
        const classes = await this.getInstitutionClasses({ institution_id, limit: 4 });
        const areas = await this.getInstitutionAreas({ institution_id, limit: 1000 });
        const current_area = await ctx.prometheusModel.CourseArea.one({ id: area_id });
        let institution_detail = await this.formatInstitutions([institution]);
        institution_detail = institution_detail[0];
        institution_detail.address = current_area.address;
        institution_detail.phone = current_area.phone;

        return { institution_detail, teachers: teachers.rows, classes: classes.rows, areas: areas.rows };
    }

    async getTeacher(teacher_id) {

        const { ctx } = this;
        const where = { id: teacher_id };
        const teacher = await ctx.prometheusModel.CourseTeacher.one({ where });
        teacher.point_tags = teacher.point.split(';');
        teacher.work_experience_tags = teacher.work_experience.split(';');

        return teacher;
    }

    async getClass(class_id) {

        const { ctx } = this;
        const where = { id: class_id };
        const classs = await ctx.prometheusModel.CourseClass.one({ where });
        classs.age_text = `${classs.min_age}-${classs.max_age}岁`;
        classs.point_tags = classs.point.split(';');
        classs.photo_album = classs.image.split(';');
        return classs;
    }

    async getInstitutionTeachers(input) {

        const { ctx } = this;
        const attributes = ['id', 'institution_id', 'name', 'avatar', 'teacher_experience', 'lesson', 'educational_background', 'certificate'];
        const { institution_id, page, limit } = input;
        const where = { institution_id };
        const teachers = await ctx.prometheusModel.CourseTeacher.list({ attributes, page, limit, where });

        return teachers;

    }

    async getInstitutionClasses(input) {

        const { ctx } = this;
        const attributes = ['id', 'institution_id', 'name', 'image', 'type', 'price'];
        const { institution_id, page, limit } = input;
        const where = { institution_id };
        const classes = await ctx.prometheusModel.CourseClass.list({ attributes, page, limit, where });
        const ret = [];
        for (let i in classes.rows) {
            let classs = classes.rows[i];
            // classs.price_text = classs.price ? classs.price : '现场咨询';
            ret.push(classs);
        }

        return { page, count: classes.count, rows: ret };

    }

    async getInstitutionAreas(input) {

        const { ctx } = this;
        const attributes = ['id', 'institution_id', 'name', 'address', 'phone'];
        const { institution_id, page, limit } = input;
        const where = { institution_id };
        const areas = await ctx.prometheusModel.CourseArea.list({ attributes, page, limit, where });

        return areas;

    }

    //机构列表页
    async getInstitutions(input) {

        const { ctx } = this;
        const { cat, age, institution } = input;
        let where = { status: 1, is_deleted: 0 };
        if (cat) {
            const cat_ret = await ctx.prometheusModel.CourseCat.one({ where: { id: cat } });
            const cat_id = cat_ret.id;
            const cat_level = cat_ret.level;
            const next_level = cat_level + 1;
            const next_next_level = cat_level + 2;
            const next_cat = await ctx.prometheusModel.CourseCat.all({ where: { level: next_level, parent_id: cat_id } });
            const next_next_cat = await ctx.prometheusModel.CourseCat.all({ where: { level: next_next_level, first_id: cat_id } });
            let cat_ids = [cat_id,];
            cat_ids = cat_ids.concat(R.pluck('id', next_cat)).concat(R.pluck('id', next_next_cat));
            const institutions = await ctx.prometheusModel.CourseInstitutionToCat.all({ where: { cat_id: { $in: cat_ids } } });
            where.id = { $in: R.pluck('institution_id', institutions) };
        }
        if (age) {
            where.max_age = { $gte: age };
            where.min_age = { $lte: age };
        }
        if (institution) {
            where.corner = { $ne: '' };
        }
        const institutions = await ctx.prometheusModel.CourseInstitution.all({ where });
        const ret = await this.formatInstitutions(institutions);

        return ret;
    }

    async formatInstitutions(institutions) {

        if (!Array.isArray(institutions) || institutions.length === 0) {
            return [];
        }
        const ret = [];
        for (let i in institutions) {
            const institution = institutions[i];
            const age_tag = institution.min_age + '-' + institution.max_age + '岁';
            const build_time = moment().format('YYYY') - institution.establishment_time;
            const tags = [age_tag, institution.class_type, '成立' + build_time + '年'];
            const photo_album = institution.image.split(';');
            ret.push({
                id: institution.id,
                name: institution.name,
                image: photo_album[0],
                establishment_time: institution.establishment_time,
                class_type: institution.class_type,
                teacher_count: institution.teacher_count,
                teacher_experience: institution.teacher_experience,
                corner: institution.corner,
                min_age: institution.min_age,
                max_age: institution.max_age,
                price: institution.price,
                tags,
                area_id: 1,//校区id
                travel_tips: 'XXXXX',
                characteristic: institution.characteristic,
            });
        }

        return ret;
    }







}

module.exports = InstitutionService;
