'use strict';

const moment = require('moment');

module.exports = app => {
    const { INTEGER, STRING, DATE } = app.Sequelize;
    const DuxiaomanLog = app.prometheusModel.define('duxiaoman_log', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        user_id: STRING,
        app_user_id: STRING,
        app_id: STRING,
        app_type_id: STRING,
        user_sid: INTEGER,
        phone: STRING,
        is_target_user: INTEGER,
        request: STRING,
        respones: STRING,
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'duxiaoman_log',
        });

    return DuxiaomanLog;

};
