
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const crypto = require('crypto')

const APPID = '';
const SECRET = '';

class UserService extends Service {

    //微信用户注册和注册登录信息等

    /**
     * 获取session_key等
     * @param {*} code 小程序拿到的wx.login的code
     */
    async requestWxAuth(code) {
        const { ctx } = this;
        const url = `https://api.weixin.qq.com/sns/jscode2session?appid=${APPID}&secret=${SECRET}&js_code=${code}&grant_type=authorization_code`;

        const result = await ctx.helper.send_request(url, {}, { method: 'GET' });
        // const result = {"data":{"session_key":"Ce7HE1+MXfyZpWLYmkP0Iw==","openid":"oSjKI5LlG6AF7_vdV5Qb_DsbHcf4"},"status":200,"headers":{"connection":"keep-alive","content-type":"text/plain","date":"Tue, 24 Sep 2019 06:18:58 GMT","content-length":"82"},"res":{"status":200,"statusCode":200,"statusMessage":"OK","headers":{"connection":"keep-alive","content-type":"text/plain","date":"Tue, 24 Sep 2019 06:18:58 GMT","content-length":"82"},"size":82,"aborted":false,"rt":113,"keepAliveSocket":false,"data":{"session_key":"Ce7HE1+MXfyZpWLYmkP0Iw==","openid":"oSjKI5LlG6AF7_vdV5Qb_DsbHcf4"},"requestUrls":["https://api.weixin.qq.com/sns/jscode2session?appid=wx4769ebba9b91f8ec&secret=680440637b4e38c9b66529cfd5dc590e&js_code=021678ss18NNAk0Fohps1oA6ss1678sT&grant_type=authorization_code"],"timing":{"queuing":15,"dnslookup":15,"connected":27,"requestSent":57,"waiting":111,"contentDownload":113},"remoteAddress":"101.227.162.120","remotePort":443,"socketHandledRequests":1,"socketHandledResponses":1}};
        ctx.logger.info(JSON.stringify({ cdWxUserAuth: result }));
        if (result.status !== 200) {
            ctx.failed('授权失败');
        }
        const ret = result.data;
        if (!ret.session_key && !ret.openid && ret.errcode !== 0) {
            ctx.failed(ret.errmsg);
        }
        const openid = ret.openid;
        const session_key = ret.session_key;

        return { openid, session_key };
    }

    /**
     * 微信官网提供的函数
     * @param {object} params [encryptedData,iv,sessionKey]
     */
    async decryptData(params) {
        // base64 decode
        var sessionKey = new Buffer(params.sessionKey, 'base64')
        let encryptedData = new Buffer(params.encryptedData, 'base64')
        let iv = new Buffer(params.iv, 'base64')
        try {
            // 解密
            var decipher = crypto.createDecipheriv('aes-128-cbc', sessionKey, iv)
            // 设置自动 padding 为 true，删除填充补位
            decipher.setAutoPadding(true)
            var decoded = decipher.update(encryptedData, 'binary', 'utf8')
            decoded += decipher.final('utf8')

            decoded = JSON.parse(decoded)

        } catch (err) {
            throw new Error('Illegal Buffer')
        }

        if (decoded.watermark.appid !== APP) {
            throw new Error('Illegal Buffer')
        }

        return decoded
    }


    /**
     * 用户同意手机号授权注册,返回五要素
     * copy的device_init里面的函数
     * @param {string} phone 用户微信绑定的手机号
     */
    async register(phone) {
        const { ctx } = this;
        let channel_alias = 'wxxcx';
        let app_channel_info = await ctx.blockModel.AppChannel.one({ where: { alias: channel_alias } });
        if (!app_channel_info || !app_channel_info.app_id || !app_channel_info.channel_id) {
            app_channel_info = await ctx.blockModel.AppChannel.one({ where: { alias: 'n_1_18100_appstore' } });// 如果配置的渠道未渠道信息，使用默认的渠道，以防出错
        }
        const app_id = app_channel_info.app_id;
        const channel_id = app_channel_info.channel_id;
        const go_register_params = {
            phone,
            app_id,
            channel_id,
        };
        const result_go_register = await ctx.helper.send_request(ctx.app.config.NODE_URL + '/login/go_register', go_register_params, { method: 'POST' });// 通过手机号直接注册新用户中心
        const node_user_center_login_ret = result_go_register.data;
        ctx.logger.info(JSON.stringify({ url: ctx.app.config.NODE_URL + '/login/go_register', middleware_go_register_params: go_register_params, middleware_result_go_register: result_go_register }));
        if (!node_user_center_login_ret.token || !node_user_center_login_ret.uid || !node_user_center_login_ret.app_user_id) {
            return {};
        }
        const user_login_info = {
            user_id: node_user_center_login_ret.uid,
            app_user_id: node_user_center_login_ret.app_user_id,
            token: node_user_center_login_ret.token,
            device_id: node_user_center_login_ret.device_id,
            device_login_id: node_user_center_login_ret.device_login_logs_id,
        };
        return user_login_info;
    }

    /**
     * 解密获得手机号
     * @param {*} params 
     */
    async userAuth(params) {
        const { ctx } = this;
        let code = params.code;
        let encryptedData = params.data;
        let iv = params.iv;

        //暂时就传我的用户编号
        let userInfo = {
            user_id: '64ce8e93-5c3d-4f9f-9bc6-05385b8213f7',
            app_user_id: 'ac152654-2cc2-4b84-8b81-31329c720a26',
            token: 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJkYXRhIjp7ImFwcF91c2VyX2lkIjoiYWMxNTI2NTQtMmNjMi00Yjg0LThiODEtMzEzMjljNzIwYTI2IiwicGFzc3BvcnQiOiIxODM1ODMzNTc0NyIsImFwcF9pZCI6ImExOGIyYjdiLWFmMDUtNDM1MC04NDUxLTA1ZTE2ZDEzNmQyZSIsInVpZCI6IjY0Y2U4ZTkzLTVjM2QtNGY5Zi05YmM2LTA1Mzg1YjgyMTNmNyIsImxvZ2luX3R5cGUiOiIxIiwiYWNjb3VudF9pZCI6ImRiZmQ5Y2FiLWZkOTMtNDk1ZC05ZGZkLWQ0ZTA2ODYyYTQwZiIsImNoYW5uZWxfaWQiOiI2NDgzODAxMC00NTg0LTExZTktYTgzNi05ZDNkY2ZkNjRkNGUiLCJkZXZpY2VfaWQiOiI4MjI5ZGQ2Yy1mMTljLTQ5MjEtODRkZS05ZTkxMWEyNmM5YWMiLCJvaWQiOiI0NDk3OXZiYjFvWUVKWG9FIiwiZGV2aWNlX2xvZ2luX2xvZ3NfaWQiOiJmZjlhMDhjOC1lZWU5LTQ5YjQtODFhMC1kZGJiMjlkNDc0MGQiLCJhcHBfdHlwZV9pZCI6IjIxNTBkMGYxLWVlMDctNGQxNy1hMDE5LTI1MWJlMzY5OWJkMSJ9LCJleHAiOjE1ODU4MDg2NDAsImlhdCI6MTU4MzIxNjYzOX0.knn0vZVHHQ24_pFKX44UPt7x_aqhK8LNz5Wk8U0S4-g',
            device_id: '8229dd6c-f19c-4921-84de-9e911a26c9ac',
            device_login_id: 'ff9a08c8-eee9-49b4-81a0-ddbb29d4740d'
        }
        return userInfo;

        //获取微信session_key
        let wxAuth = await this.requestWxAuth(code);
        //解密获得手机号
        let decodeData = await this.decryptData({ encryptedData, iv, sessionKey: wxAuth.session_key });
        ctx.logger.info('decodeData------:' + JSON.stringify(decodeData));
        // {
        //     "phoneNumber": "13580006666",
        //     "purePhoneNumber": "13580006666",
        //     "countryCode": "86",
        //     "watermark":
        //     {
        //         "appid":"APPID",
        //         "timestamp": TIMESTAMP
        //     }
        // }
        let phone = decodeData.purePhoneNumber;
        if (phone.length !== 11) {
            ctx.failed('暂时只支持11位手机号');
        }
        let userInfo = await this.register(phone);
        return userInfo;
    }


}

module.exports = UserService;
