'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM, TEXT } = app.Sequelize;
  const ZhirenInvestmentType = app.huodongModel.define('zhiren_investment_type', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    name: STRING,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('updated_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
      timestamps: false,
      tableName: 'zhiren_investment_type',
    });

    ZhirenInvestmentType.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await ZhirenInvestmentType.findOne({
      attributes: attributes,
      where: where,
    });
  }


  ZhirenInvestmentType.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const order = data.order ? data.order : [];
    return await ZhirenInvestmentType.findAll({
      attributes: attributes,
      where: where,
      order: order,
    });
  }

  ZhirenInvestmentType.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };
    console.log(condition);
    const { count, rows } = await ZhirenInvestmentType.findAndCountAll(condition);
    return { page, count, rows };
  }

  ZhirenInvestmentType.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await ZhirenInvestmentType.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      ctx.status = 500;
      throw (error);
    }
  }

  ZhirenInvestmentType.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    ZhirenInvestmentType.update(params, {
      where: where
    }).catch(e => res.json({ status: 500, error: e }));
  }

  return ZhirenInvestmentType;

};
