'use strict';

const Controller = require('egg').Controller;
const WECHAT_CODE_URL = 'https://open.weixin.qq.com/connect/oauth2/authorize';
const WECHAT_AUTH = 'https://api.weixin.qq.com/sns/oauth2/access_token';
const WECHAT_APPID = '';
const WECHAT_SECRET = '';
const NO_GJJ_PAGE = 'https://www.baidu.com';
const GJJ_DETAIL_PAGE = 'https:www.jianbing.com';
class WechatController extends Controller {


    async oauthLogin() {

        const { ctx } = this;
        const code = ctx.query.code;
        if (!code || code.length === 0) {
            const target_url = WECHAT_CODE_URL + `?appid=${WECHAT_APPID}&redirect_uri=${encodeURIComponent(`https://p.jianbing.com/51ucenter/api/user/oauth?business_url=${encodeURIComponent(business_url)}&login_url=${encodeURIComponent(login_url)}&appid=${appid}&`)}&response_type=code&scope=snsapi_base&state=gjjquery#wechat_redirect`;
            ctx.redirect(target_url);
        }
        const url = `${WECHAT_AUTH}?appid=${WECHAT_APPID}&secret=${WECHAT_SECRET}&code=${code}&grant_type=authorization_code`
        const result = await ctx.helper.send_request(url, {}, { method: 'GET' });
        if (result.status !== 200) {
            ctx.failed('获取openid失败');
        }
        const wx_ret = result.data;
        if (!wx_ret.openid) {
            ctx.failed('获取openid失败');
        }
        const openid = wx_ret.openid;

        //判断是否已绑定手机号
        const user_exist_url = `${this.app.config.NODE_BASE_URL}/user_api/v1/user/is_exist/${openid}`;
        const bind_phone_result = await ctx.helper.send_request(user_exist_url, {}, { method: 'GET' });
        if (bind_phone_result.status !== 200) {
            ctx.redirect(NO_GJJ_PAGE); return;
        }
        const user_exist_ret = bind_phone_result.data;
        if (user_exist_ret.result != 'true') {//未绑定的手机号时
            ctx.redirect(NO_GJJ_PAGE); return;
        }
        const user_id = user_exist_ret.uid;
        //判断是否有导入公积金
        const gjj_exist_url = `${this.app.config.NODE_BASE_URL}/cassandra-server/gjj/list/${user_id}`;
        const gjj_exist_result = await ctx.helper.send_request(gjj_exist_url, {}, { method: 'GET' });
        if (gjj_exist_result.status !== 200) {
            ctx.redirect(NO_GJJ_PAGE); return;
        }
        const gjj_exist_ret = gjj_exist_result.data;
        if (!gjj_exist_ret.ret || gjj_exist_ret.ret.length === 0) {//没有导入公积金时
            ctx.redirect(NO_GJJ_PAGE); return;
        }

        const login_params = {
            code: code,
            login_type: '5',
            passport: code,
            password: code,
            openid: openid,
        }
        await ctx.service.user.user_login(login_params);//用户直接登录

        ctx.redirect(GJJ_DETAIL_PAGE); return;
    }

    async checkLogin() {

        const { ctx } = this;
        const user_id = ctx.userId;
        let is_login = false;
        if (user_id) {
            is_login = true;
        }
        const phone = await ctx.helper.getPhoneCity('15968762898');
        ctx.success({ result: is_login, phone });
    }

}
module.exports = WechatController;
