'use strict';

const Controller = require('egg').Controller;

class searchHistoryController extends Controller {

    /**
     * 获取搜索历史
     */
    async getSearchHistory() {
        const { ctx } = this;
        //获取租房2和新房1的搜索记录
        let inputParams = ctx.params;
        const rule = {
            city_code: {
                type: 'string',
                required: true,
            }
        };
        ctx.validate(rule, inputParams);
        let ret = {};
        let type = [1, 2];
        for (let i in type) {
            let tag = type[i] === 1 ? 'new_house' : 'rental_house';
            ret[tag] = await ctx.service.house.v2.searchHistory.getSearchHistoryList({ type: type[i], city_code: Number(inputParams.city_code) });
        }

        ctx.success(ret);
    }


    /**
     * 清除搜索记录
     */
    async cleanSearchHistory() {
        const { ctx } = this;
        let inputParams = ctx.params;
        const cfg = {
            new_house: 1,
            rental_house: 2,
            hot_question: 3,
        }
        const rule = {
            type: {
                type: 'string',
                required: true,
            }
        };
        ctx.validate(rule, inputParams);
        if (!cfg.hasOwnProperty(inputParams.type)) {
            ctx.failed('error type');
        }
        let type = cfg[inputParams.type];
        let ret = await ctx.service.house.v2.searchHistory.cleanSearchHistory(type);
        ctx.success(ret);
    }

    /**
    * 获取热门问题搜索历史
    */
    async getHotQuestionSearchHistory() {
        const { ctx } = this;
        let type = 3;
        let ret = await ctx.service.house.v2.searchHistory.getSearchHistory(type);
        ctx.success(ret);
    }

}

module.exports = searchHistoryController;
