'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM, FLOAT } = app.Sequelize;

  const CourseOnlineArea = app.classModel.define('course_online_area', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    institution_id: INTEGER,
    name: STRING,
    address: STRING,
    phone: STRING,
    lat: DECIMAL,
    lng: DECIMAL,
    status: ENUM('offline', 'online'),
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_online_area',
  });

  CourseOnlineArea.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await CourseOnlineArea.findOne({
      attributes,
      where,
    });
  };

  CourseOnlineArea.all = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const order = data.order ? data.order : [];
    return await CourseOnlineArea.findAll({
      attributes,
      where,
      order,
    });
  };

  CourseOnlineArea.list = async (data = {}) => {
    const limit = data.limit ? Number(data.limit) : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where,
      order,
      attributes,
    };
    const { count, rows } = await CourseOnlineArea.findAndCountAll(condition);
    return { page, count, rows };
  };

  CourseOnlineArea.add = async data => {
    try {
      // 返回promise对象实力 instance
      const res = await CourseOnlineArea.create(data);
      // 从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      throw (error);
    }
  };

  CourseOnlineArea.edit = async data => {
    const where = data.where;
    const params = data.params;
    try {
      const res = await CourseOnlineArea.update(params, { where });
      return res;
    } catch (error) {
      throw (error);
    }
  };

  return CourseOnlineArea;

};
