'use strict';

const Controller = require('egg').Controller;

class CallriskController extends Controller {

    /**
     * 获取黑名单报告
     */
    async getReport() {

        const { ctx } = this;
        const report_id = ctx.params.report_id;
        if (!report_id) {
            ctx.failed('error report id');
        }
        const ret = await ctx.service.credit.callrisk.getReport(report_id);
        ctx.success(ret);

    }

    /**
     * 进入个人通话风险检测页面
     */
    async callriskInit() {
        const { ctx } = this;
        const ret = await ctx.service.credit.apply.callriskInit();
        ctx.success(ret);
    }

    /**
     * 获取数据报告信息
     */
    async applyCallriskReport() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const rule = {
            name: { type: 'string', required: true },
            phone: { type: 'string', required: true },
            id_card: { type: 'string', required: true },
            password: { type: 'string', required: true }
        }
        ctx.validate(rule, input_params);
        await ctx.service.credit.callrisk.checkThreeElements(input_params);
        const ret = await ctx.service.credit.apply.applyCallrisk(input_params);
        ctx.success(ret);

    }

    async confirmCaptcha() {

        const { ctx } = this;
        const code = ctx.request.body.code;
        const result = await ctx.service.credit.callrisk.verifyCode(code);
        // const result = true;
        ctx.success({ result });

    }


}

module.exports = CallriskController;
