'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;

  const CourseV5AgeToFilter = app.classModel.define('course_v5_age_to_filter', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    age_id: INTEGER,
    cat_id: INTEGER,
    type: INTEGER,
    column_type: INTEGER,
    column: STRING,
    column_option: INTEGER,
    column_value: STRING,
    column_score: INTEGER,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_age_to_filter',
  });

  return CourseV5AgeToFilter;

};
