'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, ENUM, TEXT, DATE } = app.Sequelize;
    const CdNewsTag = app.realestateModel.define('cd_news_tag', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        tag: {
            type: STRING,
            allowNull: true
        },
        status: {
            type: ENUM('online', 'offline'),
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
    }, {
            timestamps: false,
            tableName: 'cd_news_tag',
        });

    return CdNewsTag;

};
