'use strict';

const Controller = require('egg').Controller;

class AnswerController extends Controller {

    /**
     * 回答
     */
    async answer() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            answer: { type: 'string', required: true },
            id: { type: 'integer', required: true },
            city_code: { type: 'string', required: true },
        };
        ctx.validate(rule, inputParams);
        if (inputParams.answer.length > 500) {
            ctx.failed('最多输入500个字符');
        }
        let ret = await ctx.service.house.v2.hotQuestionAnswer.addAnswer(inputParams);
        ctx.success(ret);
    }

}

module.exports = AnswerController;
