
'use strict';

const Service = require('egg').Service;

class HouseImageService extends Service {


    async all(data) {
        const { ctx } = this;
        const pageIndex = data.page || 1;
        const pageSize = data.pageSize || 10;
        const queryConditions = data.queryConditions || [];
        const orderConditions = data.orderConditions || [];

        data.queryConditions = queryConditions;
        data.orderConditions = orderConditions;

        data.pageIndex = pageIndex;
        data.pageSize = pageSize;
        ctx.logger.info('houseimage_list_params: ' + JSON.stringify(data));
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/houseimage/list', data, { method: 'POST', dataType: 'json' });
        ctx.logger.info('houseimage_list_result: ' + JSON.stringify(result));
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async one(id) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/houseimage/' + id, {}, { method: 'GET', dataType: 'json' });
        ctx.logger.info('house_image_result: ' + JSON.stringify(result));
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }

        return result;
    }


}

module.exports = HouseImageService;
