'use strict';

module.exports = app => {
  const router = app.router.namespace(app.config.projectRootPath + '/course/v5');
  // const miniAuth = app.middleware.miniAuthV5();// 因为不跟现有的用户中心系统，所以使用单独的登录中间件
  const auth = app.middleware.verifyAuth;
  // const xmlparse = app.middleware.xmlparse();

  router.post('third', '/verification_code', 'course.v5.user.sendVerificationCode');// 发送验证码
  router.post('third', '/login/phone', 'course.v5.user.loginByPhone');// 手机号登录
  router.post('third', '/login/wechat', 'course.v5.user.loginByWX');// 微信登录
  router.post('third', '/login/app', 'course.v5.user.loginByApp');// app授权登录
  router.post('third', '/user/register_user', auth({ is_force: 0 }), 'course.v5.user.registerUserInfo');// 授权后注册用户
  router.get('third', '/user/info', auth({ is_force: 1 }), 'course.v5.user.getUserInfo');// 获取用户信息
  router.post('third', '/user/baby', auth({ is_force: 1 }), 'course.v5.user.addUserBaby');// 上传用户宝宝信息
  router.post('third', '/user/address', auth({ is_force: 1 }), 'course.v5.user.addUserAddress');// 新增用户收货地址
  router.get('third', '/user/address', auth({ is_force: 1 }), 'course.v5.user.getUserAddress');// 获取用户收货地址
  router.get('third', '/user/order/all', auth({ is_force: 1 }), 'course.v5.user.getUserOrderList');// 获取订单列表
  router.post('third', '/user/redeem/class', auth({ is_force: 1 }), 'course.v5.user.redeemClass');// 兑换课程
  router.post('third', '/user/act/image', auth({ is_force: 1 }), 'course.v5.user.addUserActImages');// 更新用户礼品列表
  router.get('third', '/user/act/image/all', auth({ is_force: 1 }), 'course.v5.user.getUserActImageList');// 获取用户礼品列表

  router.get('third', '/category/all', auth({ is_force: 0 }), 'course.v5.option.getCategoryList');// 获取分类列表
  router.get('third', '/banner/all', 'course.v5.option.getBannerList');// 获取banner列表
  router.get('third', '/options', 'course.v5.option.getOptions');// 获取配置项
  router.post('third', '/wechat/qrcode', 'course.v5.wechat.getQRCode');// 获取二维码
  router.post('third', '/wechat/unlimited_code', 'course.v5.wechat.getUnlimitedCode');// 获取小程序码
  router.get('third', '/feedback/type', 'course.v5.option.getFeedbackTypeList');// 获取反馈分类
  router.post('third', '/feedback', auth({ is_force: 1 }), 'course.v5.option.addFeedback');// 反馈
  router.get('third', '/category/tip', auth({ is_force: 1 }), 'course.v5.option.getCategoryTip');// 获取分类提示（年龄不符合）
  router.get('third', '/wechat/callbackAction', 'course.v5.wechat.check');
  router.post('third', '/wechat/callbackAction', 'course.v5.wechat.callbackAction');
  router.post('third', '/wechat/test', 'course.v5.wechat.test');
  router.post('third', '/wechat/pay/notify', 'course.v5.wechat.payNotify');
  router.post('third', '/questionnaire', auth({ is_force: 1 }), 'course.v5.option.addQuestionnaire');// 填写问卷
  router.get('third', '/questionnaire', 'course.v5.option.getQuestionnaire');// 获取问卷
  router.post('third', '/channel/unlimited_code', 'course.v5.option.addUnlimitedCodeByChannel');// 保存渠道小程序码
  router.get('third', '/channel/unlimited_code', 'course.v5.option.getUnlimitedCodeByChannel');// 获取渠道小程序码
  router.get('third', '/setting', 'course.v5.option.getSetting');// 获取配置项


  router.get('third', '/class/all', auth({ is_force: 0 }), 'course.v5.institution.getClassList');// 获取课程列表
  router.get('third', '/class/:class_id', auth({ is_force: 0 }), 'course.v5.institution.getClassInfo');// 获取课程详情

  router.get('third', '/collection/class/all', auth({ is_force: 1 }), 'course.v5.institution.getCollectionClassList');// 获取收藏课程列表
  router.post('third', '/collection/class/:class_id', auth({ is_force: 1 }), 'course.v5.institution.collectClass');// 收藏课程
  router.delete('third', '/collection/class/:class_id', auth({ is_force: 1 }), 'course.v5.institution.delCollectClass');// 取消收藏课程

  router.get('third', '/article', 'course.v5.institution.getArticleByCategory');// 获取科普文章

  router.get('third', '/question/all', auth({ is_force: 1 }), 'course.v5.report.getQuestionList');// 获取问题列表
  router.post('third', '/report', auth({ is_force: 1 }), 'course.v5.report.generateReport');// 生成报告
  router.get('third', '/report/all', auth({ is_force: 1 }), 'course.v5.report.getReportList');// 获取报告列表
  router.get('third', '/recommend/class/all', auth({ is_force: 1 }), 'course.v5.report.getAllReportRecommendClassList');// 获取所有报告推荐课程
  router.get('third', '/report/:report_id', auth({ is_force: 0 }), 'course.v5.report.getReportById');// 获取报告详情

  router.get('third', '/niutongshe', auth({ is_force: 0 }), 'course.v5.institution.getNiutongshe');// 牛通社首页

  router.get('third', '/search/recommend', auth({ is_force: 0 }), 'course.v5.institution.getSearchRecommend');// 搜索联想
  router.get('third', '/search', auth({ is_force: 0 }), 'course.v5.institution.getSearch');// 搜索

  router.get('third', '/video/all', auth({ is_force: 0 }), 'course.v5.institution.getVideoList');// 获取视频列表
  router.get('third', '/video/:id', auth({ is_force: 1 }), 'course.v5.institution.getVideoInfo');// 获取视频详情

  router.get('third', '/home/class/all', auth({ is_force: 0 }), 'course.v5.institution.getHomeClassList');// 获取课程首页

  router.post('third', '/order/class/:class_id', auth({ is_force: 1 }), 'course.v5.user.buyClass');// 购买课程

  router.get('third', '/act/image/all', 'course.v5.option.getActImageList');// 获取礼品列表
};
