'use strict';
const moment = require('moment');
module.exports = app => {
  const { INTEGER, DATE, TEXT } = app.Sequelize;
  const LogLoanRecommend = app.huodongModel.define('log_loan_recommend', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    user_sid: INTEGER,
    type: INTEGER,
    need_smart_recommend: INTEGER,
    is_smart_recommend: INTEGER,
    pass_rate_list: TEXT,
    business_list: TEXT,
    c_class_list: TEXT,
    common_loan_list: TEXT,
    page_type: INTEGER,
    is_run_pass_rate: INTEGER,
    created_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_time');
        return (date && date.toString() !== 'Invalid Date') ? moment(date).format('YYYY-MM-DD HH:mm:ss') : '0000-00-00 00:00:00';
      },
    },
  }, {
    timestamps: false,
    tableName: 'log_loan_recommend',
  });

  return LogLoanRecommend;
};
