'use strict';

const Controller = require('egg').Controller;

class RentalHouseController extends Controller {

  async getRentHouses() {
    const { ctx } = this;
    const input_params = ctx.query;
    const rule = {
      brand: { type: 'string', required: false },//品牌
      district: { type: 'string', required: false },//区域
      price: { type: 'enum', required: false, values: ['1', '2', '4', '5', '6', '7', '8', '9'] },//价格
      house_type: { type: 'enum', required: false, values: ['1', '2', '4', '5', '6'] },//房型
    };
    ctx.validate(rule, input_params);
    const ret = await ctx.service.house.rentalHouse.getRentalHouses(input_params);
    ctx.success(ret);
  }

}

module.exports = RentalHouseController;
