
'use strict';

const Service = require('egg').Service;

class RentalHouseService extends Service {


    async all(data) {
        const { ctx } = this;
        const pageIndex = data.page || 1;
        const pageSize = data.pageSize || 10;
        const queryConditions = data.queryConditions || [];
        const orderConditions = data.orderConditions || [];
        const sum = queryConditions.length;
        for (let i = 0; i < sum; i++) {
            if (queryConditions[i].key === 'userId' && queryConditions[i].value.length === 0) {
                queryConditions[i].value = true;
                queryConditions[i].operator = 'isnull';
            }
        }
        data.queryConditions = queryConditions;
        if (Object.keys(orderConditions).length === 0) {
            data.orderConditions = [{
                key: 'OrderNum',
                orderSequence: 'asc',
            }];
        }
        data.orderConditions = orderConditions;
        data.pageIndex = pageIndex;
        data.pageSize = pageSize;
        console.info(data);
        ctx.logger.info('rentalhouse_list_conditions: ' + JSON.stringify(data));
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/rentalhouse/list', data, { method: 'POST', dataType: 'json' });
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }

    async one(id) {
        const { ctx } = this;
        const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/rentalhouse/' + id, {}, {});
        if (result.status !== 200) {
            let err = '';
            if (typeof (result.data) !== 'string') {
                err = JSON.stringify(result.data);
            } else {
                err = result.data;
            }
            ctx.failed(err);
        }
        return result.data;
    }


}

module.exports = RentalHouseService;
