'use strict';
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;


    const CourseArea = app.classModel.define('course_area');

    const CourseInstitution = app.classModel.define('course_institution', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        name: STRING,
        type: STRING,
        // image: STRING,
        establishment_time: STRING,
        class_type: STRING,
        teacher_count: INTEGER,
        teacher_experience: INTEGER,
        corner: STRING,
        min_age: INTEGER,
        max_age: INTEGER,
        price: STRING,
        characteristic: STRING,
        description: TEXT,
        honor: STRING,
        point: STRING,
        status: ENUM('offline', 'online'),
        is_deleted: INTEGER,
        created_time: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'course_institution',
        });

    CourseInstitution.hasMany(CourseArea, {
        foreignKey: {
            name: 'institution_id',
            allowNull: false
        }
    });

    CourseInstitution.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await CourseInstitution.findOne({
            attributes: attributes,
            where: where,
        });
    }

    CourseInstitution.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await CourseInstitution.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    CourseInstitution.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await CourseInstitution.findAndCountAll(condition);
        return { page, count, rows };
    }

    CourseInstitution.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await CourseInstitution.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    CourseInstitution.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            const res = await CourseInstitution.update(params, { where: where })
            return res;
        } catch (error) {
            throw (error);
        }
    }

    return CourseInstitution;

};