
'use strict';

const Service = require('egg').Service;

const PRICE_RANGE = {
    1: { name: '2000元以下', min: 0, max: 2000 },
    2: { name: '2000元-3000元', min: 2000, max: 3000 },
    3: { name: '3000元-4000元', min: 3000, max: 4000 },
    4: { name: '4000元-5000元', min: 4000, max: 5000 },
    5: { name: '5000元-6000元', min: 5000, max: 6000 },
    6: { name: '6000元-7000元', min: 6000, max: 7000 },
    7: { name: '7000元-8000元', min: 7000, max: 8000 },
    8: { name: '8000元-10000元', min: 8000, max: 10000 },
    9: { name: '10000元以上', min: 10000, max: 10000000000000 },
}

const HOUSE_TYPE = {
    1: { name: '1室', min: 1, max: 1 },
    2: { name: '2室', min: 2, max: 2 },
    3: { name: '3室', min: 3, max: 3 },
    4: { name: '4室', min: 4, max: 4 },
    5: { name: '5室以上', min: 5, max: 10000 },
    6: { name: '别墅', min: 10000, max: 10000000 },
}

class RentalHouseService extends Service {

    async getRentalHousesByFilter(condition) {

        const { ctx } = this;
        const queryConditions = [];
        if (condition.brand) {
            queryConditions.push();
        }
        const filter = {
            pageSize: 30,
            queryConditions: [{
                key: "state",
                value: 1,
                operator: "equal"
            }, {
                key: "price",
                value: 19000,
                operator: "greater"
            }, {
                key: "price",
                value: 29000,
                operator: "less"
            },],
            orderConditions: [{
                key: 'price',
                orderSequence: 'asc',
            },],
        }
        const rental_houses_results = await ctx.service.houseCommon.rentalHouse.all(filter);
        return rental_houses_results;
    }

    async getRentalHouse(rental_house_id) {

        const { ctx } = this;

        //获取房源基本信息
        const house_basic = await ctx.service.houseCommon.rentalHouse.one(rental_house_id);
        if(!house_basic || !house_basic.id){
            ctx.failed('house not found');
        }

        //获取房源图片信息
        const house_image_filter = {
            queryConditions: [
                {
                    key: 'state',
                    value: 1,
                    operator: 'equal'
                },
                {
                    key: 'type',
                    value: 0,
                    operator: 'equal'
                },
                {
                    key: 'connectId',
                    value: house_basic.id,
                    operator: 'equal'
                },
            ],

        };
        const house_images_results = await ctx.service.houseCommon.houseImage.all(house_image_filter);
        const house_images = house_images_results.results;
        
        return {house_basic, house_images};
    }

}

module.exports = RentalHouseService;
